/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.moveskills;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class RegisterMoveSkillPacket
extends AbstractPixelmonPacket {
    private MoveSkill moveSkill;
    private boolean unregister = false;

    public RegisterMoveSkillPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public RegisterMoveSkillPacket(MoveSkill moveSkill) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.moveSkill = moveSkill;
    }

    public RegisterMoveSkillPacket(MoveSkill moveSkill, boolean unregister) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.moveSkill = moveSkill;
        this.unregister = unregister;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.moveSkill = new MoveSkill(buf.m_130277_());
        this.unregister = buf.readBoolean();
        if (!this.unregister) {
            int i;
            this.moveSkill.setName(buf.m_130277_());
            int descCount = buf.readByte();
            for (int i2 = 0; i2 < descCount; ++i2) {
                this.moveSkill.descriptions.add(buf.m_130277_());
            }
            this.moveSkill.sprite = ResourceLocationHelper.of(buf.m_130277_());
            this.moveSkill.anyMoves = Sets.newHashSet();
            int n = buf.readUnsignedByte();
            for (i = 0; i < n; ++i) {
                AttackRegistry.getAttackBase(buf.m_130277_()).ifPresent(attack -> this.moveSkill.anyMoves.add((ImmutableAttack)attack));
            }
            this.moveSkill.combinationMoves = Sets.newHashSet();
            n = buf.readUnsignedByte();
            for (i = 0; i < n; ++i) {
                AttackRegistry.getAttackBase(buf.m_130277_()).ifPresent(attack -> this.moveSkill.combinationMoves.add((ImmutableAttack)attack));
            }
            this.moveSkill.ableSpecs = Sets.newHashSet();
            n = buf.readUnsignedByte();
            for (i = 0; i < n; ++i) {
                this.moveSkill.ableSpecs.add(PokemonSpecificationProxy.create(buf.m_130277_()).get());
            }
            this.moveSkill.intrinsicSpecs = Sets.newHashSet();
            n = buf.readUnsignedByte();
            for (i = 0; i < n; ++i) {
                this.moveSkill.intrinsicSpecs.add(PokemonSpecificationProxy.create(buf.m_130277_()).get());
            }
            this.moveSkill.behaviours = Maps.newHashMap();
            n = buf.readByte();
            for (i = 0; i < n; ++i) {
                this.moveSkill.behaviours.put(MoveSkill.EnumTargetType.values()[buf.readByte()], (pix, o) -> 1);
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.moveSkill.id);
        buffer.writeBoolean(this.unregister);
        if (!this.unregister) {
            buffer.m_130070_(this.moveSkill.name);
            buffer.writeByte(this.moveSkill.descriptions.size());
            for (String description : this.moveSkill.descriptions) {
                buffer.m_130070_(description);
            }
            buffer.m_130070_(this.moveSkill.sprite.toString());
            buffer.writeByte(this.moveSkill.anyMoves.size());
            for (ImmutableAttack moveID : this.moveSkill.anyMoves) {
                buffer.m_130070_(moveID.getAttackName());
            }
            buffer.writeByte(this.moveSkill.combinationMoves.size());
            for (ImmutableAttack moveID : this.moveSkill.combinationMoves) {
                buffer.m_130070_(moveID.getAttackName());
            }
            buffer.writeByte(this.moveSkill.ableSpecs.size());
            for (PokemonSpecification spec : this.moveSkill.ableSpecs) {
                buffer.m_130070_(spec.toString());
            }
            buffer.writeByte(this.moveSkill.intrinsicSpecs.size());
            for (PokemonSpecification spec : this.moveSkill.intrinsicSpecs) {
                buffer.m_130070_(spec.toString());
            }
            buffer.writeByte(this.moveSkill.behaviours.keySet().size());
            for (MoveSkill.EnumTargetType targetType : this.moveSkill.behaviours.keySet()) {
                buffer.writeByte((int)((byte)targetType.ordinal()));
            }
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ClientProxy.moveSkills.removeIf(moveSkill -> moveSkill.id.equals(this.moveSkill.id));
        if (!this.unregister) {
            ClientProxy.moveSkills.add(this.moveSkill);
        }
    }
}

