/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.mail;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.MailEvent;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.items.heldItems.MailItem;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class MailPacket
extends AbstractPixelmonPacket {
    private boolean sealed;
    private String contents;

    public MailPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public MailPacket(Boolean sealed, String contents) {
        super(PacketDirection.PLAY_SERVER, true);
        this.sealed = sealed;
        this.contents = contents;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.sealed = buf.readBoolean();
        this.contents = buf.m_130277_();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.sealed);
        buf.m_130070_(this.contents);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        ItemStack letter = player.m_21205_();
        if (letter.m_41619_() || !(letter.m_41720_() instanceof MailItem)) {
            return;
        }
        if (ForgeRegistries.ITEMS.getKey((Object)letter.m_41720_()).m_135815_().contains("closed")) {
            return;
        }
        if (this.contents.split("\n").length > 14) {
            return;
        }
        for (String line : this.contents.split("\n")) {
            if (line.length() <= 200) continue;
            return;
        }
        MailEvent.EditMail.Pre preEdit = new MailEvent.EditMail.Pre(player, letter, letter.m_41784_().m_128461_("contents"), this.contents);
        if (Pixelmon.EVENT_BUS.post((Event)preEdit)) {
            return;
        }
        CompoundTag CompoundTag2 = new CompoundTag();
        CompoundTag2.m_128365_("author", (Tag)StringTag.m_129297_((String)player.m_7755_().getString()));
        CompoundTag2.m_128365_("contents", (Tag)StringTag.m_129297_((String)this.contents));
        CompoundTag2.m_128365_("editable", (Tag)ByteTag.m_128273_((boolean)true));
        Pixelmon.EVENT_BUS.post((Event)new MailEvent.EditMail.Post(player, preEdit.getMailItem(), preEdit.getBeforeText(), preEdit.getAfterText()));
        ItemStack stack = new ItemStack((ItemLike)(this.sealed ? ((MailItem)letter.m_41720_()).getClosed() : letter.m_41720_()), 1);
        stack.m_41751_(CompoundTag2);
        MailEvent.SealMail.Pre preSeal = null;
        if (this.sealed) {
            preSeal = new MailEvent.SealMail.Pre(player, preEdit.getMailItem(), stack, preEdit.getAfterText(), player.m_7755_().getString());
            if (Pixelmon.EVENT_BUS.post((Event)preSeal)) {
                stack = new ItemStack((ItemLike)letter.m_41720_(), 1);
                stack.m_41751_(CompoundTag2);
            } else {
                CompoundTag2.m_128365_("author", (Tag)StringTag.m_129297_((String)preSeal.getAuthor()));
                CompoundTag2.m_128365_("contents", (Tag)StringTag.m_129297_((String)preSeal.getText()));
                CompoundTag2.m_128365_("editable", (Tag)ByteTag.m_128273_((boolean)false));
                stack.m_41751_(CompoundTag2);
            }
        }
        if (preEdit.getMailItem().m_41613_() > 1) {
            preEdit.getMailItem().m_41774_(1);
        } else {
            player.m_150109_().m_36057_(preEdit.getMailItem());
        }
        player.m_36356_(stack);
        player.f_36095_.m_38946_();
        if (this.sealed) {
            Pixelmon.EVENT_BUS.post((Event)new MailEvent.SealMail.Post(player, preSeal.getOpenItemStack(), preSeal.getSealedItemStack(), preSeal.getText(), preSeal.getAuthor()));
        }
    }
}

