/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.itemDrops;

import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DropItemQueryList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ServerItemDropPacket
extends AbstractPixelmonPacket {
    private int itemID;
    private PacketMode mode;

    public ServerItemDropPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public ServerItemDropPacket(PacketMode mode) {
        super(PacketDirection.PLAY_SERVER, true);
        this.mode = mode;
    }

    public ServerItemDropPacket(int itemID) {
        super(PacketDirection.PLAY_SERVER, true);
        this.mode = PacketMode.TakeItem;
        this.itemID = itemID;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.mode = PacketMode.values()[buffer.readInt()];
        if (this.mode == PacketMode.TakeItem) {
            this.itemID = buffer.readInt();
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.mode.ordinal());
        if (this.mode == PacketMode.TakeItem) {
            buffer.writeInt(this.itemID);
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        switch (this.mode) {
            case DropAllItems: {
                DropItemQueryList.dropAllItems(player);
                break;
            }
            case TakeAllItems: {
                DropItemQueryList.takeAllItems(player);
                break;
            }
            case TakeItem: {
                DropItemQueryList.takeItem(player, this.itemID);
            }
        }
    }

    public static enum PacketMode {
        DropAllItems,
        TakeAllItems,
        TakeItem;

    }
}

