/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.itemDrops;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.ItemDropsScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.BattleGuiClosedPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.itemDrops.ItemDropMode;
import com.pixelmonmod.pixelmon.comm.packetHandlers.itemDrops.ServerItemDropPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DroppedItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class ItemDropPacket
extends AbstractPixelmonPacket {
    public DroppedItem[] items;
    public boolean hasCustomTitle = false;
    public ItemDropMode mode;
    public MutableComponent customTitle;

    public ItemDropPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public ItemDropPacket(ItemDropMode mode, List<DroppedItem> givenDrops) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.items = givenDrops.toArray(new DroppedItem[0]);
        this.mode = mode;
    }

    public ItemDropPacket(ItemDropMode mode, MutableComponent customTitle, List<DroppedItem> drops) {
        this(mode, drops);
        this.hasCustomTitle = true;
        this.customTitle = customTitle;
    }

    public ItemDropPacket(MutableComponent customTitle, ArrayList<DroppedItem> drops) {
        this(ItemDropMode.Other, customTitle, drops);
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.mode = ItemDropMode.values()[buffer.readInt()];
        this.items = new DroppedItem[buffer.readShort()];
        this.hasCustomTitle = buffer.readBoolean();
        int actualLength = this.items.length;
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = DroppedItem.fromBytes(buffer);
            if (this.items[i] != null) continue;
            --actualLength;
        }
        if (actualLength != this.items.length) {
            DroppedItem[] newItems = new DroppedItem[actualLength];
            int newItemIndex = 0;
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i] == null || newItemIndex >= actualLength) continue;
                newItems[newItemIndex++] = this.items[i];
            }
            this.items = newItems;
        }
        if (this.hasCustomTitle) {
            try {
                this.customTitle = Component.Serializer.m_130701_((String)buffer.m_130136_(Short.MAX_VALUE));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.mode.ordinal());
        buffer.writeShort(this.items.length);
        buffer.writeBoolean(this.hasCustomTitle);
        for (DroppedItem item : this.items) {
            item.toBytes(buffer);
        }
        if (this.hasCustomTitle) {
            try {
                buffer.m_130070_(Component.Serializer.m_130703_((Component)this.customTitle));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(CustomPayloadEvent.Context context) {
        if (PixelmonConfigProxy.getGeneral().getDrops().isUseDropGUI() || this.mode != ItemDropMode.NormalPokemon) {
            ServerStorageDisplay.bossDrops = this;
            if (ClientProxy.battleManager.battleEnded && !ClientProxy.battleManager.hasMoreMessages()) {
                Minecraft.m_91087_().m_91152_((Screen)new ItemDropsScreen());
            }
        } else {
            NetworkHelper.sendToServer(new ServerItemDropPacket(ServerItemDropPacket.PacketMode.TakeAllItems));
            NetworkHelper.sendToServer(new BattleGuiClosedPacket());
        }
    }
}

