/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.evolution;

import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.EvolveScreen;
import com.pixelmonmod.pixelmon.client.gui.ItemDropsScreen;
import com.pixelmonmod.pixelmon.client.gui.TradingScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.EvoInfo;
import com.pixelmonmod.pixelmon.client.gui.raids.RaidCatchScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class OpenEvolutionGUIPacket
extends AbstractPixelmonPacket {
    private UUID pokemonUUID;
    private String name;

    public OpenEvolutionGUIPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public OpenEvolutionGUIPacket(UUID pokemonUUID, String name) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.pokemonUUID = pokemonUUID;
        this.name = name;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.pokemonUUID = buffer.m_130259_();
        this.name = buffer.m_130277_();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.pokemonUUID);
        buffer.m_130070_(this.name);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(CustomPayloadEvent.Context context) {
        boolean exists = false;
        for (int i = 0; i < ClientProxy.battleManager.evolveList.size(); ++i) {
            if (!ClientProxy.battleManager.evolveList.get((int)i).pokemonUUID.equals(this.pokemonUUID)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            ClientProxy.battleManager.evolveList.add(new EvoInfo(this.pokemonUUID, this.name));
        }
        if (!(!ClientProxy.battleManager.battleEnded || Minecraft.m_91087_().f_91080_ instanceof BattleScreen || Minecraft.m_91087_().f_91080_ instanceof TradingScreen || Minecraft.m_91087_().f_91080_ instanceof ItemDropsScreen || Minecraft.m_91087_().f_91080_ instanceof RaidCatchScreen)) {
            Minecraft.m_91087_().m_91152_((Screen)new EvolveScreen());
        }
    }
}

