/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.evolution;

import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolutionStage;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class EvolvePokemonPacket
extends AbstractPixelmonPacket {
    private UUID pokemonUUID;
    private EvolutionStage stage;

    public EvolvePokemonPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public EvolvePokemonPacket(UUID pokemonUUID, EvolutionStage stage) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.pokemonUUID = pokemonUUID;
        this.stage = stage;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.pokemonUUID = buffer.m_130259_();
        this.stage = EvolutionStage.values()[buffer.readInt()];
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.pokemonUUID);
        buffer.writeInt(this.stage.ordinal());
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        PixelmonEntity pixelmon = ScreenHelper.getEntity(this.pokemonUUID);
        if (pixelmon != null) {
            pixelmon.setEvolutionAnimationStage(this.stage);
            pixelmon.evoAnimTicks = 0;
        }
    }
}

