/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.editor;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.ImportRequestHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class ImportResponsePacket
extends AbstractPixelmonPacket {
    private List<Pokemon> response;
    private String error;
    private String failedValue;

    public ImportResponsePacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public ImportResponsePacket(List<Pokemon> response) {
        this();
        this.response = response;
    }

    public ImportResponsePacket(String error, String failedValue) {
        this();
        this.error = error;
        this.failedValue = failedValue;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.response == null);
        if (this.response == null) {
            buffer.m_130070_(this.error);
            buffer.m_130070_(this.failedValue);
        } else {
            buffer.writeInt(this.response.size());
            for (Pokemon pokemon : this.response) {
                pokemon.writeToByteBuffer(buffer, new EnumUpdateType[0]);
            }
        }
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        boolean errorCode = buffer.readBoolean();
        if (errorCode) {
            this.error = buffer.m_130277_();
            this.failedValue = buffer.m_130277_();
        } else {
            int size = buffer.readInt();
            this.response = Lists.newArrayList();
            for (int i = 0; i < size; ++i) {
                this.response.add(PokemonFactory.create(buffer));
            }
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        if (!(Minecraft.m_91087_().f_91080_ instanceof ImportRequestHandler)) {
            return;
        }
        if (this.response != null) {
            ((ImportRequestHandler)Minecraft.m_91087_().f_91080_).handleResponse(this.response.toArray(new Pokemon[0]));
        } else {
            ((ImportRequestHandler)Minecraft.m_91087_().f_91080_).handleResponse(this.error, this.failedValue);
        }
    }
}

