/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.editor;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.export.PokemonConverterFactory;
import com.pixelmonmod.pixelmon.api.pokemon.export.exception.PokemonImportException;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.editor.ImportResponsePacket;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ImportRequestPacket
extends AbstractPixelmonPacket {
    private List<String> lines;

    public ImportRequestPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public ImportRequestPacket(List<String> lines) {
        this();
        this.lines = lines;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.lines.size());
        for (String line : this.lines) {
            buffer.m_130070_(line);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        this.lines = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            this.lines.add(buffer.m_130277_());
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        try {
            NetworkHelper.sendPacket(context.getSender(), new ImportResponsePacket(PokemonConverterFactory.importText(this.lines)));
        }
        catch (PokemonImportException e) {
            NetworkHelper.sendPacket(context.getSender(), new ImportResponsePacket(e.getReason(), e.getFailedValue()));
        }
    }
}

