/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.editor;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.export.PokemonConverterFactory;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.editor.ExportResponsePacket;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ExportRequestPacket
extends AbstractPixelmonPacket {
    private Pokemon[] pokemon;

    public ExportRequestPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public ExportRequestPacket(Pokemon ... pokemon) {
        this();
        this.pokemon = pokemon;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.pokemon.length);
        for (Pokemon pokemon : this.pokemon) {
            buffer.writeBoolean(pokemon != null);
            if (pokemon == null) continue;
            pokemon.writeToByteBuffer(buffer, new EnumUpdateType[0]);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        ArrayList pokemon = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            if (!buffer.readBoolean()) continue;
            pokemon.add(PokemonFactory.create(buffer));
        }
        this.pokemon = pokemon.toArray(new Pokemon[0]);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        NetworkHelper.sendPacket(context.getSender(), new ExportResponsePacket(PokemonConverterFactory.getFormattedExportedText(this.pokemon)));
    }
}

