/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.dialogue;

import com.pixelmonmod.pixelmon.api.dialogue.Dialogue;
import com.pixelmonmod.pixelmon.client.gui.custom.dialogue.DialogueScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SetDialogueDataPacket
extends AbstractPixelmonPacket {
    private boolean openGui = false;
    private int numDialogues = 0;
    private List<Dialogue> dialogues = new ArrayList<Dialogue>();
    private UUID quest = null;

    public SetDialogueDataPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public SetDialogueDataPacket(List<Dialogue> dialogues) {
        super(PacketDirection.PLAY_CLIENT, true);
        if (dialogues != null) {
            this.numDialogues = dialogues.size();
        }
        this.dialogues = dialogues;
    }

    public SetDialogueDataPacket(List<Dialogue> dialogues, boolean openGui) {
        this(dialogues);
        this.openGui = openGui;
    }

    public SetDialogueDataPacket(List<Dialogue> dialogues, boolean openGui, UUID quest) {
        this(dialogues, openGui);
        this.quest = quest;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.openGui = buffer.readBoolean();
        if (buffer.readBoolean()) {
            this.quest = buffer.m_130259_();
        }
        this.numDialogues = buffer.readInt();
        for (int i = 0; i < this.numDialogues; ++i) {
            this.dialogues.add(new Dialogue(buffer, this.quest));
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.openGui);
        buffer.writeBoolean(this.quest != null);
        if (this.quest != null) {
            buffer.m_130077_(this.quest);
        }
        buffer.writeInt(this.numDialogues);
        for (Dialogue dialogue : this.dialogues) {
            dialogue.writeToBytes(buffer);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(CustomPayloadEvent.Context context) {
        DialogueScreen.setDialogues(this.dialogues, this.quest);
        if (this.openGui) {
            Minecraft.m_91087_().m_91152_((Screen)new DialogueScreen());
        }
    }
}

