/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.dialogue;

import com.pixelmonmod.pixelmon.client.gui.custom.dialogue.DialogueInputScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class OpenDialogueInputPacket
extends AbstractPixelmonPacket {
    protected Component title;
    protected Component text;
    protected String defaultText;
    protected boolean shouldCloseOnEsc;

    public OpenDialogueInputPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public OpenDialogueInputPacket(Component title, Component text, String defaultText, boolean shouldCloseOnEsc) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.title = title;
        this.text = text;
        this.defaultText = defaultText;
        this.shouldCloseOnEsc = shouldCloseOnEsc;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        FriendlyByteBuf pb = new FriendlyByteBuf((ByteBuf)buf);
        this.title = pb.m_130238_();
        this.text = pb.m_130238_();
        this.defaultText = pb.m_130136_(50);
        this.shouldCloseOnEsc = pb.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        FriendlyByteBuf pb = new FriendlyByteBuf((ByteBuf)buf);
        pb.m_130083_(this.title);
        pb.m_130083_(this.text);
        pb.m_130070_(this.defaultText);
        pb.writeBoolean(this.shouldCloseOnEsc);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(CustomPayloadEvent.Context context) {
        Minecraft.m_91087_().m_91152_((Screen)new DialogueInputScreen(this.title, this.text, this.defaultText, this.shouldCloseOnEsc));
    }
}

