/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.dialogue;

import com.pixelmonmod.pixelmon.api.dialogue.Dialogue;
import com.pixelmonmod.pixelmon.client.gui.custom.dialogue.DialogueScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class DialogueNextActionPacket
extends AbstractPixelmonPacket {
    private DialogueGuiAction action;
    private int numDialogues = 0;
    private List<Dialogue> newDialogues = null;

    public DialogueNextActionPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public DialogueNextActionPacket(DialogueGuiAction action, ArrayList<Dialogue> newDialogues) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.action = action;
        this.newDialogues = newDialogues;
        this.numDialogues = newDialogues == null ? 0 : newDialogues.size();
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.action = DialogueGuiAction.values()[buffer.readInt()];
        if (this.action == DialogueGuiAction.NEW_DIALOGUES || this.action == DialogueGuiAction.INSERT_DIALOGUES) {
            this.newDialogues = new ArrayList<Dialogue>();
            this.numDialogues = buffer.readInt();
            while (this.numDialogues-- > 0) {
                this.newDialogues.add(new Dialogue(buffer));
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.action.ordinal());
        buffer.writeInt(this.numDialogues);
        if (this.numDialogues > 0) {
            for (Dialogue dialogue : this.newDialogues) {
                dialogue.writeToBytes(buffer);
            }
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        Screen openScreen = Minecraft.m_91087_().f_91080_;
        if (openScreen instanceof DialogueScreen) {
            DialogueScreen dialogueScreen = (DialogueScreen)openScreen;
            if (this.action == DialogueGuiAction.CLOSE) {
                dialogueScreen.close();
            } else if (!DialogueScreen.isQuest()) {
                DialogueScreen.removeImmediateDialogue();
                if (this.action != DialogueGuiAction.CONTINUE) {
                    ArrayList<Dialogue> dialogues = new ArrayList<Dialogue>(this.newDialogues);
                    if (this.action == DialogueGuiAction.NEW_DIALOGUES) {
                        DialogueScreen.setDialogues(dialogues);
                    } else if (this.action == DialogueGuiAction.INSERT_DIALOGUES) {
                        DialogueScreen.insertDialogues(dialogues);
                    }
                }
                dialogueScreen.next();
            }
        }
    }

    public static enum DialogueGuiAction {
        CLOSE,
        CONTINUE,
        NEW_DIALOGUES,
        INSERT_DIALOGUES;

    }
}

