/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.daycare;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.client.gui.daycare.DayCareScreen;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class RespondDayCareChildPacket
extends AbstractPixelmonPacket {
    private boolean valid;
    private Pokemon child;
    private boolean showChild;
    private boolean showPotentialShiny;

    public RespondDayCareChildPacket(boolean valid, @Nullable Pokemon child, boolean showChild, boolean showPotentialShiny) {
        super(PacketDirection.PLAY_CLIENT);
        this.valid = valid;
        this.child = child;
        this.showChild = showChild;
        this.showPotentialShiny = showPotentialShiny;
    }

    public RespondDayCareChildPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.valid);
        buffer.writeBoolean(this.showChild);
        buffer.writeBoolean(this.showPotentialShiny);
        if (this.valid) {
            this.child.writeToByteBuffer(buffer, new EnumUpdateType[0]);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.valid = buffer.readBoolean();
        this.showChild = buffer.readBoolean();
        this.showPotentialShiny = buffer.readBoolean();
        if (this.valid) {
            this.child = PokemonFactory.create(buffer);
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (!(screen instanceof DayCareScreen)) {
            return;
        }
        if (!this.valid) {
            ((DayCareScreen)screen).setChild(null, this.showPotentialShiny);
            return;
        }
        if (this.showChild) {
            this.child.setEggCycles(-1, false);
            this.child.setEggSteps(-1);
        } else {
            this.child.makeEgg();
        }
        ((DayCareScreen)screen).setChild(this.child, this.showPotentialShiny);
    }
}

