/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.daycare;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.daycare.event.DayCareEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.egg.BreedingLogicProxy;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.RespondDayCareChildPacket;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class RequestDayCareChildPacket
extends AbstractPixelmonPacket {
    private int slotOne;
    private int slotTwo;

    public RequestDayCareChildPacket(int slotOne, int slotTwo) {
        super(PacketDirection.PLAY_SERVER);
        this.slotOne = slotOne;
        this.slotTwo = slotTwo;
    }

    public RequestDayCareChildPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.slotOne);
        buffer.writeInt(this.slotTwo);
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.slotOne = buffer.readInt();
        this.slotTwo = buffer.readInt();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        PlayerPartyStorage party = StorageProxy.getPartyNow(context.getSender());
        if (party == null) {
            return;
        }
        Pokemon slotOne = party.get(this.slotOne);
        Pokemon slotTwo = party.get(this.slotTwo);
        if (slotOne == null || slotTwo == null || slotOne.isEgg() || slotTwo.isEgg()) {
            return;
        }
        Optional<Pokemon> pokemon = BreedingLogicProxy.makeEgg(slotOne, slotTwo);
        DayCareEvent.PreEggCalculate preEvent = new DayCareEvent.PreEggCalculate(context.getSender(), party, slotOne, slotTwo, pokemon.orElse(null), pokemon.isPresent(), !slotOne.getSpecies().is(PixelmonSpecies.DITTO) || !slotTwo.getSpecies().is(PixelmonSpecies.DITTO), false);
        if (Pixelmon.EVENT_BUS.post((Event)preEvent)) {
            return;
        }
        slotOne.getHeldItemAsItemHeld().applyEffectInDaycare(slotOne, slotTwo);
        slotTwo.getHeldItemAsItemHeld().applyEffectInDaycare(slotTwo, slotOne);
        party.getDayCare().setEgg(preEvent.getCalculatedChild());
        party.getDayCare().setParentOne(slotOne.getUUID());
        party.getDayCare().setParentTwo(slotTwo.getUUID());
        this.reply(context, new RespondDayCareChildPacket(preEvent.isChildExists(), preEvent.getCalculatedChild(), preEvent.isShowChild(), preEvent.isShowPotentialShiny()));
        Pixelmon.EVENT_BUS.post((Event)new DayCareEvent.PostEggCalculate(context.getSender(), party, slotOne, slotTwo, preEvent.getCalculatedChild(), preEvent.isChildExists(), preEvent.isShowChild()));
    }
}

