/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.daycare;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.daycare.event.DayCareEvent;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.client.gui.daycare.DayCareContainer;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.items.IsiHourglassItem;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class DayCareHourglassUsedPacket
extends AbstractPixelmonPacket {
    private int[] boxes;
    private int clicked;

    public DayCareHourglassUsedPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public DayCareHourglassUsedPacket(int clicked, int ... boxes) {
        this();
        this.clicked = clicked;
        this.boxes = boxes;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.clicked);
        buffer.writeInt(this.boxes.length);
        for (int box : this.boxes) {
            buffer.writeInt(box);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.clicked = buffer.readInt();
        int size = buffer.readInt();
        this.boxes = new int[size];
        for (int i = 0; i < size; ++i) {
            this.boxes[i] = buffer.readInt();
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer sender = context.getSender();
        AbstractContainerMenu containerMenu = sender.f_36096_;
        if (!(containerMenu instanceof DayCareContainer)) {
            return;
        }
        ItemStack held = containerMenu.m_142621_();
        if (!(held.m_41720_() instanceof IsiHourglassItem)) {
            return;
        }
        IsiHourglassItem item = (IsiHourglassItem)held.m_41720_();
        IsiHourglassItem.HourGlassType type = item.getType();
        DayCareEvent.HourGlassUsed.Pre pre = new DayCareEvent.HourGlassUsed.Pre(sender, StorageProxy.getPartyNow(sender), held, (PropertyDispatch.TriFunction<ServerPlayer, Integer, int[], Boolean>)((PropertyDispatch.TriFunction)type::handle));
        if (Pixelmon.EVENT_BUS.post((Event)pre)) {
            return;
        }
        boolean handle = (Boolean)pre.getHandler().m_125475_((Object)sender, (Object)this.clicked, (Object)this.boxes);
        if (!handle) {
            return;
        }
        if (!sender.m_7500_()) {
            containerMenu.m_142621_().m_41774_(1);
            sender.f_8906_.m_141995_((Packet)new ClientboundContainerSetSlotPacket(-1, -1, -1, sender.m_150109_().m_36056_()));
            sender.m_150109_().m_6596_();
        }
        Pixelmon.EVENT_BUS.post((Event)new DayCareEvent.HourGlassUsed.Post(sender, StorageProxy.getPartyNow(sender), pre.getItem(), pre.getHandler()));
    }
}

