/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.daycare;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.breeding.DayCareBox;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class DayCareAllErrorsPacket
extends AbstractPixelmonPacket {
    private int boxId;
    private List<Component> errors;

    public DayCareAllErrorsPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public DayCareAllErrorsPacket(int boxId, List<Component> errors) {
        this();
        this.boxId = boxId;
        this.errors = errors;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.boxId);
        buffer.writeInt(this.errors.size());
        for (Component error : this.errors) {
            buffer.m_130083_(error);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.boxId = buffer.readInt();
        this.errors = Lists.newArrayList();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            this.errors.add(buffer.m_130238_());
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        PlayerPartyStorage party = ClientStorageManager.party;
        if (party == null) {
            return;
        }
        DayCareBox dayCareBox = party.getDayCare().getOrCreateBox(this.boxId).orElse(null);
        if (dayCareBox == null) {
            return;
        }
        dayCareBox.setAllErrorMessages(this.errors);
    }
}

