/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.daycare;

import com.pixelmonmod.pixelmon.api.daycare.DayCareCondition;
import com.pixelmonmod.pixelmon.api.daycare.DayCareRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.storage.breeding.DayCareBox;
import com.pixelmonmod.pixelmon.api.storage.breeding.PlayerDayCare;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.DayCareConditionStatusResponsePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.UpdateDayCareBoxPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class CompleteDayCareRequirementPacket
extends AbstractPixelmonPacket {
    private int boxId;

    public CompleteDayCareRequirementPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public CompleteDayCareRequirementPacket(int boxId) {
        this();
        this.boxId = boxId;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.boxId);
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.boxId = buffer.readInt();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer sender = context.getSender();
        PlayerDayCare dayCare = StorageProxy.getPartyNow(sender).getDayCare();
        if (dayCare == null) {
            return;
        }
        DayCareBox dayCareBox = dayCare.getOrCreateBox(this.boxId).orElse(null);
        if (dayCareBox == null || dayCareBox.isEmpty()) {
            return;
        }
        DayCareCondition currentCondition = dayCareBox.getNextCondition();
        if (currentCondition == null) {
            return;
        }
        DayCareRequirement currentRequirement = currentCondition.getNextRequirement().orElse(null);
        if (currentRequirement == null) {
            return;
        }
        if (!currentRequirement.hasMetRequirement(sender, dayCareBox)) {
            return;
        }
        if (!currentCondition.completeRequirement(sender, dayCareBox, currentRequirement)) {
            return;
        }
        if (currentCondition.isComplete()) {
            dayCareBox.completeCondition(currentCondition);
            if (dayCareBox.canBreedingBegin()) {
                dayCare.setPaidFor(dayCareBox.getParentOne().getGender() == Gender.FEMALE ? dayCareBox.getParentOne() : dayCareBox.getParentTwo());
                dayCareBox.beginBreeding();
                this.reply(context, new UpdateDayCareBoxPacket(dayCareBox));
            } else {
                DayCareCondition nextCondition = dayCareBox.getNextCondition();
                this.sendStatusResponse(context, sender, dayCareBox, nextCondition);
            }
            return;
        }
        this.sendStatusResponse(context, sender, dayCareBox, currentCondition);
    }

    private void sendStatusResponse(CustomPayloadEvent.Context context, ServerPlayer sender, DayCareBox box, DayCareCondition condition) {
        DayCareRequirement nextRequirement = condition.getNextRequirement().orElse(null);
        boolean canConsume = nextRequirement.hasMetRequirement(sender, box);
        this.reply(context, new DayCareConditionStatusResponsePacket(this.boxId, nextRequirement.getError(), canConsume));
    }
}

