/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.daycare;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.storage.breeding.DayCareBox;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.UpdateDayCareBoxPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class CancelDayCareBoxPacket
extends AbstractPixelmonPacket {
    private int boxId;

    public CancelDayCareBoxPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public CancelDayCareBoxPacket(int boxId) {
        this();
        this.boxId = boxId;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.boxId);
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.boxId = buffer.readInt();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        PlayerPartyStorage party = StorageProxy.getPartyNow(context.getSender().m_20148_());
        if (party == null) {
            return;
        }
        DayCareBox dayCareBox = party.getDayCare().getOrCreateBox(this.boxId).orElse(null);
        if (dayCareBox == null) {
            return;
        }
        dayCareBox.setEgg(null);
        dayCareBox.returnToStorage();
        this.reply(context, new UpdateDayCareBoxPacket(dayCareBox));
    }
}

