/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.custom.overlays;

import com.pixelmonmod.pixelmon.client.gui.custom.overlays.CustomScoreboardOverlay;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class CustomScoreboardUpdatePacket
extends AbstractPixelmonPacket {
    private String title;
    private Collection<String> lines;
    private Collection<String> scores;

    public CustomScoreboardUpdatePacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public CustomScoreboardUpdatePacket(String title, Collection<String> lines, Collection<String> scores) {
        super(PacketDirection.PLAY_CLIENT);
        this.title = title;
        this.lines = lines;
        this.scores = scores;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.title = buf.m_130277_();
        int lineAmount = buf.readByte();
        this.lines = new ArrayList<String>(lineAmount);
        for (int i = 0; i < lineAmount; ++i) {
            this.lines.add(buf.m_130277_());
        }
        int scoreAmount = buf.readShort();
        if (scoreAmount != 254) {
            this.scores = new ArrayList<String>(scoreAmount);
            for (int i = 0; i < scoreAmount; ++i) {
                this.scores.add(buf.m_130277_());
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.title);
        buffer.writeByte(this.lines.size());
        for (String line : this.lines) {
            buffer.m_130070_(line);
        }
        if (this.scores != null) {
            buffer.writeShort(this.scores.size());
            for (String score : this.scores) {
                buffer.m_130070_(score);
            }
        } else {
            buffer.writeShort(254);
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        CustomScoreboardOverlay.resetBoard();
        CustomScoreboardOverlay.populate(null, this.title, this.lines, this.scores);
    }
}

