/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.custom.overlays;

import com.pixelmonmod.pixelmon.client.gui.custom.overlays.CustomScoreboardOverlay;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.ScoreboardLocation;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class CustomScoreboardDisplayPacket
extends AbstractPixelmonPacket {
    private ScoreboardLocation location;
    private boolean enabled;

    public CustomScoreboardDisplayPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public CustomScoreboardDisplayPacket(ScoreboardLocation location, boolean enabled) {
        super(PacketDirection.PLAY_CLIENT);
        this.location = location;
        this.enabled = enabled;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.location = ScoreboardLocation.values()[buf.readByte()];
        this.enabled = buf.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeByte(this.location.ordinal());
        buf.writeBoolean(this.enabled);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        CustomScoreboardOverlay.setLocation(this.location);
        CustomScoreboardOverlay.setEnabled(this.enabled);
    }
}

