/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.custom.overlays;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.overlay.notice.EnumOverlayLayout;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.CustomNoticeOverlay;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.OverlayGraphicType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class CustomNoticePacketPacket
extends AbstractPixelmonPacket {
    private boolean enabled = true;
    private Component[] lines;
    private EnumOverlayLayout layout = null;
    private OverlayGraphicType type = null;
    private PokemonSpecification spec = null;
    private ItemStack itemStack = null;

    public CustomNoticePacketPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public CustomNoticePacketPacket setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public CustomNoticePacketPacket setLines(Component[] lines) {
        this.lines = lines;
        return this;
    }

    public CustomNoticePacketPacket setPokemonSprite(PokemonSpecification spec, EnumOverlayLayout layout) {
        Preconditions.checkArgument((boolean)((PokemonSpecification)Preconditions.checkNotNull((Object)spec, (Object)"spec")).getValue(SpeciesRequirement.class).isPresent(), (Object)"The spec doesn't specify a pok\u00e9mon.");
        this.type = OverlayGraphicType.PokemonSprite;
        this.spec = spec;
        this.layout = (EnumOverlayLayout)((Object)Preconditions.checkNotNull((Object)((Object)layout), (Object)"layout"));
        return this;
    }

    public CustomNoticePacketPacket setPokemon3D(PokemonSpecification spec, EnumOverlayLayout layout) {
        Preconditions.checkArgument((boolean)((PokemonSpecification)Preconditions.checkNotNull((Object)spec, (Object)"spec")).getValue(SpeciesRequirement.class).isPresent(), (Object)"The spec doesn't specify a pok\u00e9mon.");
        this.type = OverlayGraphicType.Pokemon3D;
        this.spec = spec;
        this.layout = (EnumOverlayLayout)((Object)Preconditions.checkNotNull((Object)((Object)layout), (Object)"layout"));
        return this;
    }

    public CustomNoticePacketPacket setItemStack(ItemStack itemStack, EnumOverlayLayout layout) {
        Preconditions.checkNotNull((Object)itemStack, (Object)"itemStack");
        Preconditions.checkNotNull((Object)((Object)layout), (Object)"layout");
        if (itemStack.m_41619_()) {
            return this.setEmpty();
        }
        this.type = OverlayGraphicType.ItemStack;
        this.itemStack = itemStack;
        this.layout = layout;
        return this;
    }

    public CustomNoticePacketPacket setEmpty() {
        this.type = null;
        return this;
    }

    @Deprecated
    public void setPokemonSprite(Species species, EnumOverlayLayout displayType) {
        this.setPokemonSprite(PokemonSpecificationProxy.create(species.getName()).get(), displayType);
    }

    @Deprecated
    public void setPokemon3D(Species species, EnumOverlayLayout displayType, float scale) {
        this.setPokemon3D(PokemonSpecificationProxy.create(species.getName()).get(), displayType);
    }

    @Deprecated
    public void setItemSprite(String itemName, EnumOverlayLayout displayType) {
        this.setItemStack(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocationHelper.of(itemName))), displayType);
    }

    @Deprecated
    public void setItem3D(String itemName, EnumOverlayLayout displayType) {
        this.setItemStack(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocationHelper.of(itemName))), displayType);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.enabled);
        if (!this.enabled) {
            return;
        }
        buf.writeByte(this.lines == null ? -1 : this.lines.length);
        for (Component line : this.lines) {
            buf.m_130083_(line);
        }
        buf.writeByte(this.type == null ? -1 : this.type.ordinal());
        if (this.type != null) {
            buf.writeByte(this.layout.ordinal());
            switch (this.type) {
                case PokemonSprite: 
                case Pokemon3D: {
                    buf.m_130079_((Tag)this.spec.write(new CompoundTag()));
                    break;
                }
                case ItemStack: {
                    buf.m_130055_(this.itemStack);
                }
            }
        }
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        byte typeOrdinal;
        this.enabled = buf.readBoolean();
        if (!this.enabled) {
            return;
        }
        int linesLength = buf.readByte();
        if (linesLength != -1) {
            this.lines = new Component[linesLength];
            for (int i = 0; i < linesLength; ++i) {
                this.lines[i] = buf.m_130238_();
            }
        }
        if ((typeOrdinal = buf.readByte()) != -1) {
            this.type = OverlayGraphicType.values()[typeOrdinal];
            this.layout = EnumOverlayLayout.values()[buf.readByte()];
            switch (this.type) {
                case PokemonSprite: 
                case Pokemon3D: {
                    this.spec = PokemonSpecificationProxy.fromNbt(buf.m_130260_()).get();
                    break;
                }
                case ItemStack: {
                    this.itemStack = buf.m_130267_();
                }
            }
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        if (!this.enabled) {
            CustomNoticeOverlay.setEnabled(false);
        } else {
            CustomNoticeOverlay.resetNotice();
            try {
                CustomNoticeOverlay.populate(Lists.newArrayList((Object[])this.lines));
                if (this.type != null) {
                    switch (this.type) {
                        case PokemonSprite: {
                            CustomNoticeOverlay.setPokemonSprite(this.spec, this.layout);
                            break;
                        }
                        case Pokemon3D: {
                            CustomNoticeOverlay.setPokemon3D(this.spec, this.layout);
                            break;
                        }
                        case ItemStack: {
                            CustomNoticeOverlay.setItemStack(this.itemStack, this.layout);
                        }
                    }
                }
                CustomNoticeOverlay.setEnabled(true);
            }
            catch (Exception e) {
                CustomNoticeOverlay.resetNotice();
                Pixelmon.LOGGER.error("The server is sending weird values to the overlay.", (Throwable)e);
            }
        }
    }
}

