/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.custom.drops;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.client.gui.custom.CustomDropsScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class CustomDropsOpenPacket
extends AbstractPixelmonPacket {
    private String mnemonic;
    private boolean escapeCloses;
    private Component title;
    private List<ItemStack> items;
    private Component[] buttons;

    public CustomDropsOpenPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public CustomDropsOpenPacket(String mnemonic, boolean escapeCloses, Component title, List<ItemStack> items, Component ... buttons) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.mnemonic = mnemonic;
        this.escapeCloses = escapeCloses;
        this.title = title;
        this.items = items;
        this.buttons = buttons;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        int i;
        this.mnemonic = buffer.m_130277_();
        this.escapeCloses = buffer.readBoolean();
        this.title = buffer.m_130238_();
        this.items = Lists.newArrayList();
        int size = buffer.readByte();
        for (i = 0; i < size; ++i) {
            this.items.add(buffer.m_130267_());
        }
        this.buttons = new Component[3];
        for (i = 0; i < 3; ++i) {
            this.buttons[i] = buffer.m_130238_();
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        int i;
        buffer.m_130070_(this.mnemonic);
        buffer.writeBoolean(this.escapeCloses);
        buffer.m_130083_(this.title);
        buffer.writeByte(this.items.size());
        for (i = 0; i < this.items.size(); ++i) {
            buffer.m_130055_(this.items.get(i));
        }
        for (i = 0; i < 3; ++i) {
            buffer.m_130083_(this.buttons[i]);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(CustomPayloadEvent.Context context) {
        Minecraft.m_91087_().m_91152_((Screen)new CustomDropsScreen(this.mnemonic, this.escapeCloses, this.title, this.items.toArray(new ItemStack[0]), this.buttons));
    }
}

