/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.pc;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.pc.ClientQueryResultsPCPacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;
import org.apache.commons.lang3.StringUtils;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ServerQueryPCPacket
extends AbstractPixelmonPacket {
    private int searchId;
    private String query;

    public ServerQueryPCPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public ServerQueryPCPacket(int searchId, String query) {
        super(PacketDirection.PLAY_SERVER, true);
        this.searchId = searchId;
        this.query = query;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeShort(this.searchId);
        buf.m_130070_(this.query);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.searchId = buf.readShort();
        this.query = buf.m_130277_();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        String query = this.query.replaceAll(" +", " ").toLowerCase(Locale.ROOT);
        if (!StringUtils.isBlank((CharSequence)query)) {
            PCStorage pc = StorageProxy.getPCForPlayerNow(context.getSender());
            List<Pokemon> results = this.search(pc, query);
            this.reply(context, new ClientQueryResultsPCPacket(this.searchId, results));
        }
    }

    public List<Pokemon> search(PokemonStorage storage, String query) {
        List<Pokemon> results;
        String name;
        if (query.contains(" ")) {
            name = query.substring(0, query.indexOf(" "));
            PokemonSpecification spec = PokemonSpecificationProxy.create(query.substring(query.indexOf(" ") + 1) + " !egg").get();
            results = storage.findAll(spec);
            results.removeIf(PokemonBase::isEgg);
        } else if (query.equals("eggs")) {
            name = "all";
            results = storage.findAll(PokemonBase::isEgg);
        } else {
            name = query;
            results = new ArrayList<Pokemon>(Arrays.asList(storage.getAll()));
            results.removeIf(Objects::isNull);
        }
        if (!name.equals("all")) {
            results.removeIf(poke -> poke.isEgg() && !"eggs".contains(name) || !poke.getDisplayName().toLowerCase(Locale.ROOT).contains(name) && !poke.getSpecies().getName().toLowerCase(Locale.ROOT).contains(name) && !poke.getSpecies().getName().contains(name));
        }
        return results;
    }
}

