/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.pc;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.client.gui.pc.PCScreen;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class ClientQueryResultsPCPacket
extends AbstractPixelmonPacket {
    private int searchId;
    private List<Pokemon> results;

    public ClientQueryResultsPCPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public ClientQueryResultsPCPacket(int searchId, List<Pokemon> results) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.searchId = searchId;
        this.results = results;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeShort(this.searchId);
        buf.writeShort(this.results.size());
        int box = -1;
        for (int i = 0; i < this.results.size(); ++i) {
            Pokemon pokemon = this.results.get(i);
            if (box != pokemon.getPosition().box) {
                box = pokemon.getPosition().box;
                buf.writeShort(-box - 1);
            }
            buf.writeShort(pokemon.getPosition().order);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.searchId = buf.readShort();
        this.results = new ArrayList<Pokemon>();
        int length = buf.readShort();
        int box = -1;
        for (int i = 0; i < length; ++i) {
            short x;
            short order = x = buf.readShort();
            if (x < 0) {
                box = -x - 1;
                order = buf.readShort();
            }
            this.results.add(ClientStorageManager.openPC.get(box, order));
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        if (PCScreen.search != null && PCScreen.search.searchId == this.searchId) {
            PCScreen.search.rearrangeBoxes(this.results);
        }
    }
}

