/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.pc;

import com.google.common.base.Preconditions;
import com.pixelmonmod.pixelmon.api.storage.PCBox;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class ClientInitializePCPacket
extends AbstractPixelmonPacket {
    private PCStorage storage;

    public ClientInitializePCPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public ClientInitializePCPacket(PCStorage storage) {
        super(PacketDirection.PLAY_CLIENT, true);
        Preconditions.checkNotNull((Object)storage);
        this.storage = storage;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.storage.uuid);
        buffer.writeShort(this.storage.getBoxCount());
        buffer.writeShort(this.storage.getLastBox());
        for (int i = 0; i < this.storage.getBoxCount(); ++i) {
            PCBox box = this.storage.getBox(i);
            buffer.m_130070_(box.getName() == null ? "" : box.getName());
            buffer.m_130070_(box.getWallpaper() == null ? "" : box.getWallpaper());
        }
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.storage = new PCStorage(buf.m_130259_(), buf.readShort());
        this.storage.shouldSendUpdates = false;
        this.storage.setLastBox(buf.readShort());
        for (int i = 0; i < this.storage.getBoxCount(); ++i) {
            PCBox box = this.storage.getBox(i);
            box.setName(buf.m_130277_());
            box.setWallpaper(buf.m_130277_());
            box.hasChangedClientSide = false;
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        if (this.storage.uuid.equals(Minecraft.m_91087_().f_91074_.m_20148_())) {
            this.storage.playerUUID = this.storage.uuid;
        }
        ClientStorageManager.pcs.put(this.storage.uuid, this.storage);
        if (ClientStorageManager.openPC == null || ClientStorageManager.openPC.getBoxCount() == 0) {
            ClientStorageManager.openPC = this.storage;
        }
    }
}

