/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.enums.DeleteType;
import com.pixelmonmod.pixelmon.api.events.PixelmonDeletedEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ServerTrashPacket
extends AbstractPixelmonPacket {
    private StoragePosition position;
    private UUID pokemon;

    public ServerTrashPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public ServerTrashPacket(StoragePosition position, Pokemon pokemon) {
        super(PacketDirection.PLAY_SERVER, true);
        this.position = position;
        this.pokemon = pokemon == null ? null : pokemon.getUUID();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        this.position.encode((ByteBuf)buf);
        buf.writeLong(this.pokemon.getMostSignificantBits());
        buf.writeLong(this.pokemon.getLeastSignificantBits());
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.position = StoragePosition.decode((ByteBuf)buf);
        this.pokemon = buf.m_130259_();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        PokemonStorage storage = StorageProxy.getStorageNow(context.getSender(), this.position);
        if (storage.validate(this.position, this.pokemon) && (this.position.box != -1 || storage.countPokemon() > 1 || storage.get(this.position).isEgg())) {
            Pokemon pokemon = storage.get(this.position);
            pokemon.ifEntityExists(pixelmonEntity -> pixelmonEntity.retrieve("PokemonReleased"));
            Pixelmon.EVENT_BUS.post((Event)new PixelmonDeletedEvent(context.getSender(), pokemon, DeleteType.PC));
            storage.set(this.position, null);
        } else {
            storage.notifyListener(context.getSender(), this.position, storage.get(this.position), new EnumUpdateType[0]);
        }
    }
}

