/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ServerSwapPacket
extends AbstractPixelmonPacket {
    private StoragePosition position1;
    private UUID pokemon1;
    private StoragePosition position2;
    private UUID pokemon2;

    public ServerSwapPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public ServerSwapPacket(StoragePosition position1, Pokemon pokemon1, StoragePosition position2, Pokemon pokemon2) {
        super(PacketDirection.PLAY_SERVER, true);
        this.position1 = position1;
        this.pokemon1 = pokemon1 == null ? null : pokemon1.getUUID();
        this.position2 = position2;
        this.pokemon2 = pokemon2 == null ? null : pokemon2.getUUID();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        this.position1.encode((ByteBuf)buf);
        buf.writeBoolean(this.pokemon1 != null);
        if (this.pokemon1 != null) {
            buf.writeLong(this.pokemon1.getMostSignificantBits());
            buf.writeLong(this.pokemon1.getLeastSignificantBits());
        }
        this.position2.encode((ByteBuf)buf);
        buf.writeBoolean(this.pokemon2 != null);
        if (this.pokemon2 != null) {
            buf.writeLong(this.pokemon2.getMostSignificantBits());
            buf.writeLong(this.pokemon2.getLeastSignificantBits());
        }
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.position1 = StoragePosition.decode((ByteBuf)buf);
        if (buf.readBoolean()) {
            this.pokemon1 = buf.m_130259_();
        }
        this.position2 = StoragePosition.decode((ByteBuf)buf);
        if (buf.readBoolean()) {
            this.pokemon2 = buf.m_130259_();
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer sender = context.getSender();
        PokemonStorage storage1 = StorageProxy.getStorageNow(sender, this.position1);
        PokemonStorage storage2 = StorageProxy.getStorageNow(sender, this.position2);
        if (storage1.validate(this.position1, this.pokemon1) && storage2.validate(this.position2, this.pokemon2)) {
            Pokemon fromPokemon = storage1.get(this.position1);
            Pokemon toPokemon = storage2.get(this.position2);
            if (fromPokemon != null) {
                fromPokemon.ifEntityExists(pixelmonEntity -> pixelmonEntity.retrieve("Forced"));
            }
            if (toPokemon != null) {
                toPokemon.ifEntityExists(pixelmonEntity -> pixelmonEntity.retrieve("Forced"));
            }
            storage2.transfer(storage1, this.position1, this.position2);
        } else {
            storage1.notifyListener(sender, this.position1, storage1.get(this.position1), new EnumUpdateType[0]);
            storage2.notifyListener(sender, this.position2, storage1.get(this.position2), new EnumUpdateType[0]);
        }
    }
}

