/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class ClientSetPacket
extends AbstractPixelmonPacket {
    private static final EnumUpdateType[] ALL_TYPES = EnumUpdateType.values();
    private UUID storageUUID;
    private StoragePosition position;
    private Pokemon pokemon;
    private EnumUpdateType[] dataTypes;
    private FriendlyByteBuf pokemonData;

    public ClientSetPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public ClientSetPacket(PokemonStorage storage, StoragePosition position, Pokemon pokemon, EnumUpdateType ... dataTypes) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.storageUUID = storage.uuid;
        this.position = position;
        this.pokemon = pokemon;
        if (dataTypes == null || dataTypes.length == 0) {
            dataTypes = EnumUpdateType.CLIENT;
        }
        this.dataTypes = dataTypes;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.storageUUID = buf.m_130259_();
        this.position = StoragePosition.decode((ByteBuf)buf);
        boolean deleting = buf.readBoolean();
        if (!deleting) {
            this.dataTypes = new EnumUpdateType[buf.readByte()];
            for (int i = 0; i < this.dataTypes.length; ++i) {
                this.dataTypes[i] = ALL_TYPES[buf.readByte()];
            }
            this.pokemonData = new FriendlyByteBuf(buf.copy(buf.readerIndex(), buf.readableBytes()));
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeLong(this.storageUUID.getMostSignificantBits());
        buf.writeLong(this.storageUUID.getLeastSignificantBits());
        this.position.encode((ByteBuf)buf);
        if (this.pokemon == null) {
            buf.writeBoolean(true);
        } else {
            buf.writeBoolean(false);
            buf.writeByte(this.dataTypes.length);
            for (EnumUpdateType type : this.dataTypes) {
                buf.writeByte((int)((byte)type.ordinal()));
            }
            this.pokemon.writeToByteBuffer(buf, this.dataTypes);
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        PokemonStorage storage = ClientStorageManager.getStorage(this.storageUUID, this.position);
        if (storage == null) {
            Pixelmon.LOGGER.error("No storage on the client side with UUID " + this.storageUUID.toString());
            return;
        }
        if (this.pokemonData == null) {
            storage.set(this.position, null);
        } else {
            boolean putting = false;
            Pokemon pokemon = storage.get(this.position);
            if (pokemon == null) {
                pokemon = PokemonFactory.create(UUID.randomUUID());
                putting = true;
            }
            pokemon.readFromByteBuffer(this.pokemonData, this.dataTypes);
            if (putting) {
                storage.set(this.position, pokemon);
            }
        }
    }
}

