/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage;

import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import com.pixelmonmod.pixelmon.enums.EnumTrainerCardColor;
import com.pixelmonmod.pixelmon.storage.ClientData;
import java.math.BigDecimal;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class UpdateClientPlayerDataPacket
extends AbstractPixelmonPacket {
    private ClientDataType type;
    private BigDecimal playerMoney;
    private EnumMegaItem megaItem;
    private EnumTrainerCardColor color;
    private ItemStack lureStack;

    public UpdateClientPlayerDataPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public UpdateClientPlayerDataPacket(BigDecimal playerMoney) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.playerMoney = playerMoney;
        this.type = ClientDataType.CURRENCY;
    }

    public UpdateClientPlayerDataPacket(EnumMegaItem megaItem) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.megaItem = megaItem;
        this.type = ClientDataType.MEGA_ITEM;
    }

    public UpdateClientPlayerDataPacket(EnumTrainerCardColor color) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.type = ClientDataType.TRAINER_CARD_COLOR;
        this.color = color;
    }

    public UpdateClientPlayerDataPacket(ItemStack lureStack) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.type = ClientDataType.LURE;
        this.lureStack = lureStack;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        switch (this.type) {
            case CURRENCY: {
                buf.m_130070_(this.playerMoney.toString());
                break;
            }
            case MEGA_ITEM: {
                buf.writeInt(this.megaItem.ordinal());
                break;
            }
            case TRAINER_CARD_COLOR: {
                buf.writeInt(this.color.ordinal());
                break;
            }
            case LURE: {
                if (this.lureStack == null || this.lureStack.m_41619_()) {
                    buf.writeBoolean(false);
                    break;
                }
                buf.writeBoolean(true);
                buf.m_130055_(this.lureStack);
            }
        }
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.type = ClientDataType.values()[buf.readInt()];
        switch (this.type) {
            case CURRENCY: {
                this.playerMoney = new BigDecimal(buf.m_130277_());
                break;
            }
            case MEGA_ITEM: {
                this.megaItem = EnumMegaItem.values()[buf.readInt()];
                break;
            }
            case TRAINER_CARD_COLOR: {
                this.color = EnumTrainerCardColor.values()[buf.readInt()];
                break;
            }
            case LURE: {
                this.lureStack = buf.readBoolean() ? buf.m_130267_() : ItemStack.f_41583_;
            }
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        switch (this.type) {
            case CURRENCY: {
                ClientData.playerMoney = this.playerMoney;
                break;
            }
            case MEGA_ITEM: {
                ClientData.openMegaItemGui = this.megaItem.getType();
                break;
            }
            case TRAINER_CARD_COLOR: {
                ClientData.color = this.color;
                break;
            }
            case LURE: {
                ClientStorageManager.party.setLureStack(this.lureStack);
            }
        }
    }

    public static enum ClientDataType {
        CURRENCY,
        MEGA_ITEM,
        TRAINER_CARD_COLOR,
        LURE;

    }
}

