/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.items.LureItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ChangeLurePacket
extends AbstractPixelmonPacket {
    public Change change;
    public ResourceLocation item;
    public int damage;

    public ChangeLurePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public ChangeLurePacket(Change change) {
        super(PacketDirection.PLAY_SERVER, true);
        this.change = change;
    }

    public ChangeLurePacket(Change change, Item item, int damage) {
        super(PacketDirection.PLAY_SERVER, true);
        this.change = change;
        this.item = ForgeRegistries.ITEMS.getKey((Object)item);
        this.damage = damage;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.change = Change.values()[buf.readByte()];
        if (buf.readBoolean()) {
            this.item = ResourceLocationHelper.of(buf.m_130277_());
            this.damage = buf.readInt();
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeByte(this.change.ordinal());
        buf.writeBoolean(this.item != null);
        if (this.item != null) {
            buf.m_130070_(this.item.toString());
            buf.writeInt(this.damage);
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player.f_36096_ == null) {
            return;
        }
        PlayerPartyStorage party = StorageProxy.getPartyNow(player);
        Runnable sync = () -> party.setLureStack(party.getLureStack());
        ItemStack held = player.f_36096_.m_142621_();
        if (player.m_7500_()) {
            if (this.item == null) {
                held = ItemStack.f_41583_;
            } else {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(this.item);
                if (!(item instanceof LureItem)) {
                    return;
                }
                held = new ItemStack((ItemLike)item);
                held.m_41721_(this.damage);
            }
        }
        if (this.change == Change.PUT) {
            if (party.getLure() != null || held.m_41619_() || !(held.m_41720_() instanceof LureItem)) {
                sync.run();
                return;
            }
            if (!player.m_7500_()) {
                player.f_36096_.m_142503_(ItemStack.f_41583_);
            }
            party.setLureStack(held);
        } else if (this.change == Change.SWAP) {
            if (party.getLure() == null || held.m_41619_() || !(held.m_41720_() instanceof LureItem)) {
                sync.run();
                return;
            }
            if (!player.m_7500_()) {
                player.f_36096_.m_142503_(party.getLureStack());
            }
            party.setLureStack(held);
        } else if (this.change == Change.TAKE) {
            if (party.getLure() == null || !held.m_41619_()) {
                sync.run();
                return;
            }
            ItemStack lureStack = party.getLureStack();
            party.setLureStack(null);
            if (!player.m_7500_()) {
                player.f_36096_.m_142503_(lureStack);
            }
        }
    }

    public static enum Change {
        SWAP,
        PUT,
        TAKE;

    }
}

