/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.chooseMoveset;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.chooseMoveset.ChoosingMovesetData;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ChooseMovesetPacket
extends AbstractPixelmonPacket {
    public static final Map<UUID, ChoosingMovesetData> choosingMoveset = Maps.newConcurrentMap();
    private UUID uuid;
    private List<String> attackIds = Lists.newArrayList();

    public ChooseMovesetPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public ChooseMovesetPacket(Pokemon pokemon, List<Attack> chosenAttackList) {
        super(PacketDirection.PLAY_SERVER, true);
        this.uuid = pokemon.getUUID();
        this.attackIds.addAll(chosenAttackList.stream().map(a -> a.getActualMove().getAttackName()).collect(Collectors.toList()));
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.uuid = buf.m_130259_();
        int num = buf.readShort();
        for (int i = 0; i < num; ++i) {
            this.attackIds.add(buf.m_130277_());
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.uuid);
        buf.writeShort(this.attackIds.size());
        this.attackIds.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130070_(arg_0));
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player != null && choosingMoveset.containsKey(player.m_20148_())) {
            PlayerPartyStorage party = StorageProxy.getPartyNow(player);
            Pokemon pokemon = party.find(this.uuid);
            pokemon.getMoveset().replaceWith(this.attackIds);
            ChoosingMovesetData d = choosingMoveset.get(player.m_20148_());
            if (d != null) {
                d.next();
                if (d.pokemonList.isEmpty()) {
                    choosingMoveset.remove(player.m_20148_());
                }
            }
        }
    }
}

