/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.camera;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.CameraEvent;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.SpriteItemHelper;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ItemCameraPacket
extends AbstractPixelmonPacket {
    private int entityId;

    public ItemCameraPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public ItemCameraPacket(int entityID) {
        super(PacketDirection.PLAY_SERVER, true);
        this.entityId = entityID;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.entityId = buf.m_130242_();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.entityId);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        PixelmonEntity pixelmon = (PixelmonEntity)player.m_9236_().m_6815_(this.entityId);
        if (pixelmon == null) {
            return;
        }
        if (!PixelmonConfigProxy.getItems().isMultiplePhotosOfSamePokemon() && pixelmon.cameraCapturedPlayers.contains(player.m_20148_()) && !Pixelmon.EVENT_BUS.post((Event)new CameraEvent.DuplicatePhoto(player, pixelmon))) {
            player.m_213846_((Component)Component.m_237110_((String)"camera.error.samepokemon", (Object[])new Object[]{pixelmon.getLocalizedName()}));
            return;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new CameraEvent.ConsumeFilm(player, pixelmon)) || this.clearMatchingItems(player, PixelmonItems.film) == 1) {
            ItemStack photo;
            CameraEvent.TakePhoto event;
            if (!PixelmonConfigProxy.getItems().isMultiplePhotosOfSamePokemon()) {
                pixelmon.cameraCapturedPlayers.add(player.m_20148_());
            }
            if (!Pixelmon.EVENT_BUS.post((Event)(event = new CameraEvent.TakePhoto(player, pixelmon, photo = SpriteItemHelper.getPhoto(pixelmon.getPokemon()))))) {
                player.m_150109_().m_36054_(event.photo);
                pixelmon.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundRegistration.CAMERA_SHUTTER.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            }
        }
    }

    private int clearMatchingItems(ServerPlayer player, Item item) {
        int slotMatchingUnusedItem = player.m_150109_().m_36043_(new ItemStack((ItemLike)item));
        if (slotMatchingUnusedItem == -1) {
            return 0;
        }
        ItemStack found = player.m_150109_().m_8020_(slotMatchingUnusedItem);
        if (found == ItemStack.f_41583_) {
            return 0;
        }
        found.m_41774_(1);
        return 1;
    }
}

