/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.selection;

import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.util.helpers.ArrayHelper;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.TeamSelectScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class ShowTeamSelectPacket
extends AbstractPixelmonPacket {
    public int teamSelectID;
    public String[] disabled;
    public List<PokemonBase> opponentTeam;
    public int opponentSize;
    public int npcID;
    public String npcName = "";
    public UUID opponentUUID;
    public boolean showOpponentTeam;
    public boolean closeable;
    protected BattleRules rules;
    boolean showRules;

    public ShowTeamSelectPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    private ShowTeamSelectPacket(int teamSelectID, String[] disabled, List<PokemonBase> opponentTeam, BattleRules rules, boolean showRules, boolean showOpponentTeam, boolean closeable) {
        super(PacketDirection.PLAY_SERVER, true);
        this.teamSelectID = teamSelectID;
        this.disabled = disabled;
        if (!showOpponentTeam || !rules.getOrDefault(BattleRuleRegistry.TEAM_PREVIEW).booleanValue()) {
            this.opponentSize = opponentTeam.size();
        } else {
            this.opponentTeam = opponentTeam;
        }
        this.rules = rules;
        this.showRules = showRules;
        this.showOpponentTeam = showOpponentTeam;
        this.closeable = closeable;
    }

    public ShowTeamSelectPacket(int teamSelectID, String[] disabled, List<PokemonBase> opponentTeam, int npcID, String npcName, BattleRules rules, boolean showRules, boolean showOpponentTeam, boolean closeable) {
        this(teamSelectID, disabled, opponentTeam, rules, showRules, showOpponentTeam, closeable);
        this.npcID = npcID;
        this.npcName = npcName;
    }

    public ShowTeamSelectPacket(int teamSelectID, String[] disabled, List<PokemonBase> opponentTeam, UUID opponentUUID, BattleRules rules, boolean showRules, boolean showOpponentTeam, boolean closeable) {
        this(teamSelectID, disabled, opponentTeam, rules, showRules, showOpponentTeam, closeable);
        this.opponentUUID = opponentUUID;
    }

    public boolean isAllDisabled() {
        for (String s : this.disabled) {
            if (s != null && !s.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.teamSelectID);
        ArrayHelper.encodeStringArray(buf, this.disabled);
        if (!this.showOpponentTeam || !this.rules.getOrDefault(BattleRuleRegistry.TEAM_PREVIEW).booleanValue()) {
            buf.writeBoolean(false);
            buf.writeInt(this.opponentSize);
        } else {
            buf.writeBoolean(true);
            buf.writeInt(this.opponentTeam.size());
            for (PokemonBase pokemonBase : this.opponentTeam) {
                PixelmonDataSerializers.POKEMON_BASE.m_6856_(buf, (Object)pokemonBase);
            }
        }
        if (this.opponentUUID == null) {
            buf.writeBoolean(true);
            buf.writeInt(this.npcID);
            buf.m_130070_(this.npcName);
        } else {
            buf.writeBoolean(false);
            buf.m_130077_(this.opponentUUID);
        }
        this.rules.encodeInto(buf);
        buf.writeBoolean(this.showRules);
        buf.writeBoolean(this.closeable);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.teamSelectID = buf.readInt();
        this.disabled = ArrayHelper.decodeStringArray(buf);
        this.showOpponentTeam = buf.readBoolean();
        if (this.showOpponentTeam) {
            int length = buf.readInt();
            this.opponentTeam = new ArrayList<PokemonBase>();
            for (int i = 0; i < length; ++i) {
                this.opponentTeam.add((PokemonBase)PixelmonDataSerializers.POKEMON_BASE.m_6709_(buf));
            }
        } else {
            this.opponentSize = buf.readInt();
        }
        if (buf.readBoolean()) {
            this.npcID = buf.readInt();
            this.npcName = buf.m_130277_();
        } else {
            this.opponentUUID = buf.m_130259_();
        }
        this.rules = new BattleRules();
        this.rules.decodeInto(buf);
        this.showRules = buf.readBoolean();
        this.closeable = buf.readBoolean();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handlePacket(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            ClientProxy.battleManager.rules = this.rules;
            EnumGuiScreen gui = this.showRules ? EnumGuiScreen.BattleRulesFixed : EnumGuiScreen.TeamSelect;
            TeamSelectScreen.teamSelectPacket = this;
            OpenScreenPacket.open((Player)Minecraft.m_91087_().f_91074_, gui, new int[0]);
        });
    }
}

