/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles.music;

import com.pixelmonmod.pixelmon.client.music.BattleMusic;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.sounds.BattleMusicType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class PlayBattleMusicPacket
extends AbstractPixelmonPacket {
    private BattleMusicType type;
    private int songIndex;
    private long playtime;
    private boolean repeat;

    public PlayBattleMusicPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public PlayBattleMusicPacket(BattleMusicType type, int songIndex, long playtime, boolean repeat) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.type = type;
        this.songIndex = songIndex;
        this.playtime = playtime;
        this.repeat = repeat;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.type = BattleMusicType.getFromIndex(buf.readByte());
        this.songIndex = buf.readInt();
        this.playtime = buf.readLong();
        this.repeat = buf.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeByte(this.type.ordinal());
        buf.writeInt(this.songIndex);
        buf.writeLong(this.playtime);
        buf.writeBoolean(this.repeat);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        BattleMusic.startBattleMusic(this.type, this.songIndex, this.playtime, this.repeat);
    }
}

