/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.DelegateLink;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.items.EtherItem;
import com.pixelmonmod.pixelmon.items.heldItems.BerryLeppaItem;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class UseEtherPacket
extends AbstractPixelmonPacket {
    private int moveIndex;
    private UUID pokemonUUID;

    public UseEtherPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public UseEtherPacket(int moveIndex, UUID pokemonUUID) {
        super(PacketDirection.PLAY_SERVER, true);
        this.moveIndex = moveIndex;
        this.pokemonUUID = pokemonUUID;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.moveIndex);
        buf.m_130077_(this.pokemonUUID);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.moveIndex = buf.readInt();
        this.pokemonUUID = buf.m_130259_();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        EtherItem ether;
        ServerPlayer player = context.getSender();
        ItemStack itemStack = player.m_21205_();
        if (itemStack == null) {
            return;
        }
        Item item = itemStack.m_41720_();
        PlayerPartyStorage party = StorageProxy.getPartyNow(player);
        Pokemon pokemon = party.find(this.pokemonUUID);
        if (pokemon == null) {
            return;
        }
        Attack attack = pokemon.getMoveset().get(this.moveIndex);
        if (attack == null) {
            return;
        }
        if (item instanceof EtherItem) {
            ether = (EtherItem)item;
        } else if (item instanceof BerryLeppaItem) {
            ether = PixelmonItems.ether;
        } else {
            return;
        }
        if (ether.useEther(new DelegateLink(pokemon), this.moveIndex) && !player.m_7500_()) {
            itemStack.m_41774_(1);
        }
    }
}

