/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class UpdateMovesetPacket
extends AbstractPixelmonPacket {
    private UUID uuid;
    private Moveset moveset;

    public UpdateMovesetPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public UpdateMovesetPacket(PixelmonWrapper wrapper) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.uuid = wrapper.getPokemonUUID();
        this.moveset = wrapper.getMoveset();
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.uuid = buf.m_130259_();
        this.moveset = new Moveset();
        this.moveset.fromBytes(buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeLong(this.uuid.getMostSignificantBits()).writeLong(this.uuid.getLeastSignificantBits());
        this.moveset.toBytes(buf);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        if (ClientProxy.battleManager.fullOurPokemon != null) {
            for (PixelmonClientData pig : ClientProxy.battleManager.fullOurPokemon) {
                if (!pig.pokemonUUID.equals(this.uuid)) continue;
                pig.moveset = this.moveset;
            }
        }
        if (ClientProxy.battleManager.displayedOurPokemon != null) {
            for (PixelmonClientData pig : ClientProxy.battleManager.displayedOurPokemon) {
                if (!pig.pokemonUUID.equals(this.uuid)) continue;
                pig.moveset = this.moveset;
            }
        }
    }
}

