/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class SwitchPokemonPacket
extends AbstractPixelmonPacket {
    private UUID newPokemonUUID = null;
    private int battleControllerIndex;
    private UUID switchingPokemonUUID;
    private boolean happensInstantly;

    public SwitchPokemonPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public SwitchPokemonPacket(UUID newPokemonUUID, int battleControllerIndex, UUID switchingPokemonUUID, boolean happensInstantly) {
        super(PacketDirection.PLAY_SERVER, true);
        this.newPokemonUUID = newPokemonUUID;
        this.battleControllerIndex = battleControllerIndex;
        this.switchingPokemonUUID = switchingPokemonUUID;
        this.happensInstantly = happensInstantly;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            this.newPokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
        }
        this.battleControllerIndex = buffer.readInt();
        this.switchingPokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
        this.happensInstantly = buffer.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.newPokemonUUID != null);
        if (this.newPokemonUUID != null) {
            buffer.m_130077_(this.newPokemonUUID);
        }
        buffer.writeInt(this.battleControllerIndex);
        buffer.m_130077_(this.switchingPokemonUUID);
        buffer.writeBoolean(this.happensInstantly);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        UUID newPokemonUUID;
        ServerPlayer player = context.getSender();
        BattleController bc = BattleRegistry.getBattle(this.battleControllerIndex);
        if (bc == null) {
            return;
        }
        PlayerParticipant p = bc.getPlayer((Player)player);
        if (p == null) {
            return;
        }
        if (this.newPokemonUUID == null) {
            PixelmonWrapper switching = this.findPokemon(p);
            if (switching == null) {
                return;
            }
            newPokemonUUID = p.getBattleAI().getNextSwitch(switching);
        } else {
            newPokemonUUID = this.newPokemonUUID;
        }
        bc.switchPokemon(this.switchingPokemonUUID, newPokemonUUID, this.happensInstantly);
    }

    private PixelmonWrapper findPokemon(PlayerParticipant participant) {
        for (PixelmonWrapper pixelmonWrapper : participant.allPokemon) {
            if (!Objects.equals(pixelmonWrapper.getPokemonUUID(), this.switchingPokemonUUID)) continue;
            return pixelmonWrapper;
        }
        return null;
    }
}

