/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SetPokemonBattleDataPacket
extends AbstractPixelmonPacket {
    private PixelmonClientData[] data;
    private boolean isOpponent;

    public SetPokemonBattleDataPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public SetPokemonBattleDataPacket(PixelmonClientData[] controlledPokemon) {
        this(controlledPokemon, true);
    }

    public SetPokemonBattleDataPacket(PixelmonClientData[] controlledPokemon, boolean isOpponent) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.data = controlledPokemon;
        this.isOpponent = isOpponent;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        int numPokemon = this.data.length;
        for (PixelmonClientData d : this.data) {
            if (d != null) continue;
            --numPokemon;
        }
        buffer.writeShort(numPokemon);
        for (PixelmonClientData d : this.data) {
            if (d == null) continue;
            d.encodeInto(buffer);
        }
        buffer.writeBoolean(this.isOpponent);
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.data = new PixelmonClientData[buffer.readShort()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new PixelmonClientData();
            this.data[i].decodeFrom(buffer);
        }
        this.isOpponent = buffer.readBoolean();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        if (this.isOpponent) {
            ClientProxy.battleManager.setOpponents(this.data);
        } else {
            ClientProxy.battleManager.setTeamPokemon(this.data);
        }
    }
}

