/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SetAllBattlingPokemonPacket
extends AbstractPixelmonPacket {
    private PixelmonClientData[] allPokemon;
    private boolean useOldHealthValues;

    public SetAllBattlingPokemonPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public SetAllBattlingPokemonPacket(PixelmonClientData[] allPokemon, boolean useOldHealthValues) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.allPokemon = allPokemon;
        this.useOldHealthValues = useOldHealthValues;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        int numPokemon = this.allPokemon.length;
        for (PixelmonClientData d : this.allPokemon) {
            if (d != null) continue;
            --numPokemon;
        }
        buffer.writeByte(numPokemon);
        for (PixelmonClientData d : this.allPokemon) {
            if (d == null) continue;
            d.encodeInto(buffer);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.allPokemon = new PixelmonClientData[buffer.readByte()];
        for (int i = 0; i < this.allPokemon.length; ++i) {
            this.allPokemon[i] = new PixelmonClientData();
            this.allPokemon[i].decodeFrom(buffer);
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ClientProxy.battleManager.setFullTeamData(this.allPokemon, this.useOldHealthValues);
    }
}

