/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.battles.SpectateEvent;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.Spectator;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetAllBattlingPokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetBattlingPokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokemonBattleDataPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokemonTeamDataPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.StartBattlePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.StartSpectatePacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class RequestSpectatePacket
extends AbstractPixelmonPacket {
    private UUID uuid;

    public RequestSpectatePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public RequestSpectatePacket(UUID playerId) {
        super(PacketDirection.PLAY_SERVER, true);
        this.uuid = playerId;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.uuid = new UUID(buffer.readLong(), buffer.readLong());
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeLong(this.uuid.getMostSignificantBits());
        buffer.writeLong(this.uuid.getLeastSignificantBits());
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer watcher = context.getSender();
        ServerPlayer watchedPlayer = (ServerPlayer)watcher.f_19853_.m_46003_(this.uuid);
        if (watchedPlayer == null) {
            return;
        }
        BattleController base = BattleRegistry.getBattle((Player)watchedPlayer);
        if (base == null || Pixelmon.EVENT_BUS.post((Event)new SpectateEvent.StartSpectate(watcher, base, watchedPlayer))) {
            return;
        }
        PlayerParticipant watchedParticipant = base.getPlayer(watchedPlayer.m_7755_().getString());
        if (watchedParticipant == null) {
            return;
        }
        this.reply(context, new StartBattlePacket(base.battleIndex, base.getBattleType(watchedParticipant), base.rules));
        this.reply(context, new SetAllBattlingPokemonPacket(PixelmonClientData.convertToGUI(Arrays.asList(watchedParticipant.allPokemon)), true));
        ArrayList<PixelmonWrapper> teamList = watchedParticipant.getTeamPokemonList();
        this.reply(context, new SetBattlingPokemonPacket(teamList));
        this.reply(context, new SetPokemonBattleDataPacket(PixelmonClientData.convertToGUI(teamList), false));
        this.reply(context, new SetPokemonBattleDataPacket(watchedParticipant.getOpponentData(), true));
        this.reply(context, new StartSpectatePacket(watchedPlayer.m_20148_(), base.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE)));
        if (base.getTeam(watchedParticipant).size() > 1) {
            this.reply(context, new SetPokemonTeamDataPacket(watchedParticipant.getAllyData()));
        }
        base.addSpectator(new Spectator(watcher, watchedPlayer.m_5446_().getString()));
    }
}

