/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ParticipantReadyPacket
extends AbstractPixelmonPacket {
    private UUID uuid;
    private int battleIndex;

    public ParticipantReadyPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public ParticipantReadyPacket(int battleControllerIndex, UUID uuid) {
        super(PacketDirection.PLAY_SERVER, true);
        this.uuid = uuid;
        this.battleIndex = battleControllerIndex;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.battleIndex = buf.readInt();
        this.uuid = buf.m_130259_();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.battleIndex);
        buf.m_130077_(this.uuid);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        context.getSender().m_9243_();
        BattleController bc = BattleRegistry.getBattle(this.battleIndex);
        if (bc == null) {
            return;
        }
        for (BattleParticipant participant : bc.participants) {
            if (!(participant instanceof PlayerParticipant) || !Objects.equals(((PlayerParticipant)participant).player.m_20148_(), this.uuid)) continue;
            bc.participantReady((PlayerParticipant)participant);
        }
    }
}

