/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.api.battles.BattleMode;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class OpenBattleModePacket
extends AbstractPixelmonPacket {
    private BattleMode mode;
    private int position = -1;

    public OpenBattleModePacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public OpenBattleModePacket(BattleMode mode) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.mode = mode;
    }

    public OpenBattleModePacket(BattleMode mode, int position) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.mode = mode;
        this.position = position;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.mode.ordinal());
        buf.writeInt(this.position);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.mode = BattleMode.values()[buf.readInt()];
        this.position = buf.readInt();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ClientProxy.battleManager.setMode(this.mode);
        ClientProxy.battleManager.choosingPokemon = true;
        ClientProxy.battleManager.teamPokemon = null;
        if (this.position != -1) {
            ClientProxy.battleManager.currentPokemon = this.position;
        }
        Minecraft.m_91087_().m_91152_((Screen)new BattleScreen());
    }
}

