/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.api.battles.BattleMode;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.MegaEvolution;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class MegaEvolvePacket
extends AbstractPixelmonPacket {
    private UUID pokemonUUID;
    private boolean ultraBurst;

    public MegaEvolvePacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public MegaEvolvePacket(UUID pokemonUUID, boolean ultraBurst) {
        super(PacketDirection.PLAY_CLIENT);
        this.pokemonUUID = pokemonUUID;
        this.ultraBurst = ultraBurst;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.pokemonUUID);
        buf.writeBoolean(this.ultraBurst);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.pokemonUUID = buf.m_130259_();
        this.ultraBurst = buf.readBoolean();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        if (this.ultraBurst) {
            ClientProxy.battleManager.ultraBurst = this.pokemonUUID;
            ClientProxy.battleManager.hasUltraBurst = true;
        } else {
            ClientProxy.battleManager.megaEvolution = this.pokemonUUID;
        }
        ClientProxy.battleManager.setMode(BattleMode.MEGA_EVOLUTION);
        MegaEvolution.selectEntity();
        PixelmonClientData pokemon = ClientProxy.battleManager.getPokemon(this.pokemonUUID);
        pokemon.mega = this.pokemonUUID != null;
    }
}

