/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class FormBattleUpdatePacket
extends AbstractPixelmonPacket {
    private UUID uuid;
    private String form;

    public FormBattleUpdatePacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public FormBattleUpdatePacket(UUID uuid, String form) {
        super(PacketDirection.PLAY_CLIENT);
        this.uuid = uuid;
        this.form = form;
    }

    public FormBattleUpdatePacket(UUID uuid, Stats form) {
        super(PacketDirection.PLAY_CLIENT);
        this.uuid = uuid;
        this.form = form.getName();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.uuid);
        buf.m_130070_(this.form);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.uuid = buf.m_130259_();
        this.form = buf.m_130277_();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        PixelmonClientData pokemon = ClientProxy.battleManager.getPokemon(this.uuid);
        if (pokemon != null && !pokemon.isSwitchingOut && !pokemon.inIllusion) {
            pokemon.prevForm = pokemon.form;
            pokemon.form = this.form;
        }
    }
}

