/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class FleePacket
extends AbstractPixelmonPacket {
    private UUID fleeingPokemonUUID;

    public FleePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public FleePacket(UUID fleeingPokemonUUID) {
        super(PacketDirection.PLAY_SERVER, true);
        this.fleeingPokemonUUID = fleeingPokemonUUID;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.fleeingPokemonUUID = buffer.m_130259_();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.fleeingPokemonUUID);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        BattleController battleController = BattleRegistry.getBattle((Player)player);
        if (battleController == null) {
            return;
        }
        for (BattleParticipant participant : battleController.participants) {
            if (!(participant instanceof PlayerParticipant) || ((PlayerParticipant)participant).player != player) continue;
            battleController.setFlee(this.fleeingPokemonUUID);
        }
    }
}

