/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class DynamaxPacket
extends AbstractPixelmonPacket {
    private UUID pokemonUUID;
    private boolean gigantamax;

    public DynamaxPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public DynamaxPacket(UUID pokemonUUID, boolean gigantamax) {
        super(PacketDirection.PLAY_CLIENT);
        this.pokemonUUID = pokemonUUID;
        this.gigantamax = gigantamax;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.pokemonUUID);
        buf.writeBoolean(this.gigantamax);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.pokemonUUID = buf.m_130259_();
        this.gigantamax = buf.readBoolean();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ClientProxy.battleManager.gigantamax = this.gigantamax;
        ClientProxy.battleManager.dynamax = this.pokemonUUID;
        PixelmonClientData pokemon = ClientProxy.battleManager.getPokemon(this.pokemonUUID);
        if (pokemon == null) {
            return;
        }
        pokemon.dynamax = this.pokemonUUID != null ? (this.gigantamax ? 2 : 1) : 0;
    }
}

