/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.ArrayHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.ExitBattlePacket;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ChooseAttackPacket
extends AbstractPixelmonPacket {
    private int buttonId;
    private boolean[][] targetting;
    private int battleIndex;
    public UUID pokemonUUID;
    public boolean megaEvolving;
    public boolean dynamaxing;

    public ChooseAttackPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public ChooseAttackPacket(UUID pokemonUUID, boolean[][] targetting, int buttonId, int battleIndex, boolean megaEvolving, boolean dynamaxing) {
        super(PacketDirection.PLAY_SERVER);
        this.pokemonUUID = pokemonUUID;
        this.buttonId = buttonId;
        this.battleIndex = battleIndex;
        this.targetting = ArrayHelper.deepCopy(targetting);
        this.megaEvolving = megaEvolving;
        this.dynamaxing = dynamaxing;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        int i;
        this.pokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
        this.buttonId = buffer.readInt();
        this.battleIndex = buffer.readInt();
        this.targetting = new boolean[buffer.readShort()][];
        for (i = 0; i < this.targetting.length; ++i) {
            this.targetting[i] = new boolean[buffer.readShort()];
        }
        for (i = 0; i < this.targetting.length; ++i) {
            for (int j = 0; j < this.targetting[i].length; ++j) {
                this.targetting[i][j] = buffer.readBoolean();
            }
        }
        this.megaEvolving = buffer.readBoolean();
        this.dynamaxing = buffer.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.pokemonUUID);
        buffer.writeInt(this.buttonId);
        buffer.writeInt(this.battleIndex);
        buffer.writeShort(this.targetting.length);
        for (boolean[] aTargetting1 : this.targetting) {
            buffer.writeShort(aTargetting1.length);
        }
        for (boolean[] aTargetting : this.targetting) {
            for (int j = 0; j < aTargetting.length; ++j) {
                buffer.writeBoolean(aTargetting[j]);
            }
        }
        buffer.writeBoolean(this.megaEvolving);
        buffer.writeBoolean(this.dynamaxing);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        BattleController battleController = BattleRegistry.getBattle(this.battleIndex);
        player.m_9243_();
        if (battleController == null) {
            this.reply(context, new ExitBattlePacket());
            return;
        }
        BattleParticipant battleParticipant = battleController.getParticipantForEntity((LivingEntity)player);
        if (battleParticipant == null) {
            this.reply(context, new ExitBattlePacket());
            return;
        }
        PixelmonWrapper pixelmonWrapper = battleParticipant.getPokemonFromUUID(this.pokemonUUID);
        if (pixelmonWrapper == null) {
            battleController.battleLog.onCrash(new Exception("Invalid pokemon"), "Invalid pokemon selected! player:" + player.m_7755_() + " pokemon:" + this.pokemonUUID.toString());
            return;
        }
        BattleParticipant parent = pixelmonWrapper.getParticipant();
        if (this.buttonId == -1) {
            pixelmonWrapper.chooseMove(parent.getBattleAI().getNextMove(pixelmonWrapper));
            return;
        }
        if (this.buttonId < 4 && (this.megaEvolving || this.dynamaxing)) {
            Attack attack = pixelmonWrapper.getMoveset().get(this.buttonId);
            if (attack == null || attack.pp <= 0 || attack.getDisabled() && !this.dynamaxing && !pixelmonWrapper.isDynamax()) {
                battleController.battleLog.onCrash(new Exception("Invalid attack"), "Invalid attack selected! player:" + player.m_7755_() + " pokemon:" + this.pokemonUUID.toString() + " index:" + this.buttonId);
                return;
            }
            PlayerPartyStorage storage = StorageProxy.getPartyNow(player);
            this.megaEvolving = storage.getMegaItem().canEvolve() || pixelmonWrapper.getSpecies().is(PixelmonSpecies.RAYQUAZA);
            this.dynamaxing = storage.getMegaItem().canDynamax();
        } else {
            this.megaEvolving = false;
            this.dynamaxing = false;
        }
        pixelmonWrapper.setAttack(this.buttonId, this.findTargets(battleController, parent), this.megaEvolving || this.dynamaxing);
    }

    private List<PixelmonWrapper> findTargets(BattleController battleController, BattleParticipant battleParticipant) {
        ArrayList targets = Lists.newArrayList();
        ArrayList<PixelmonWrapper> teamPokemon = battleController.getTeamPokemon(battleParticipant);
        for (int i = 0; i < this.targetting[0].length; ++i) {
            if (!this.targetting[0][i] || i >= teamPokemon.size()) continue;
            targets.add((PixelmonWrapper)teamPokemon.get(i));
        }
        ArrayList<PixelmonWrapper> opponentPokemon = battleController.getOpponentPokemon(battleParticipant);
        for (int i = 0; i < this.targetting[1].length; ++i) {
            if (!this.targetting[1][i]) continue;
            if (battleController.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.DOUBLE || battleController.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.SINGLE || battleController.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.RAID) {
                if (i < opponentPokemon.size()) {
                    targets.add((PixelmonWrapper)opponentPokemon.get(i));
                }
            } else {
                for (PixelmonWrapper pokemon : opponentPokemon) {
                    if (pokemon.battlePosition != i) continue;
                    targets.add(pokemon);
                }
            }
            if (!targets.isEmpty()) continue;
            PixelmonWrapper fallback = (PixelmonWrapper)opponentPokemon.get(opponentPokemon.size() - 1);
            if (targets.contains(fallback)) break;
            targets.add(fallback);
            break;
        }
        return targets;
    }
}

