/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.ShowSpectateMessagePacket;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class CheckPlayerBattlePacket
extends AbstractPixelmonPacket {
    private UUID uuid;

    public CheckPlayerBattlePacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public CheckPlayerBattlePacket(Player player) {
        super(PacketDirection.PLAY_SERVER);
        this.uuid = player.m_20148_();
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.uuid = new UUID(buffer.readLong(), buffer.readLong());
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeLong(this.uuid.getMostSignificantBits());
        buffer.writeLong(this.uuid.getLeastSignificantBits());
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer sender = context.getSender();
        if (sender == null || sender.m_9236_() == null || this.uuid == null) {
            return;
        }
        Player player = sender.m_9236_().m_46003_(this.uuid);
        if (player != null && BattleRegistry.getBattleExcludeSpectate(player) != null) {
            this.reply(context, new ShowSpectateMessagePacket(this.uuid));
        }
    }
}

