/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.client.gui.battles.AcceptDenyScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class BattleQueryPacket
extends AbstractPixelmonPacket {
    public UUID opponentUUID;
    public int queryIndex;
    public String[] pokeballs = new String[]{"", "", "", "", "", ""};

    public BattleQueryPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public BattleQueryPacket(int queryIndex, UUID opponentUUID, PlayerPartyStorage opponentStorage) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.queryIndex = queryIndex;
        this.opponentUUID = opponentUUID;
        for (int i = 0; i < 6; ++i) {
            if (opponentStorage.getAll()[i] != null) {
                this.pokeballs[i] = opponentStorage.getAll()[i].getBall().getName();
                if (!opponentStorage.getAll()[i].isFainted()) continue;
                this.pokeballs[i] = "!" + this.pokeballs[i];
                continue;
            }
            this.pokeballs[i] = "";
        }
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.queryIndex = buffer.readInt();
        this.opponentUUID = buffer.m_130259_();
        for (int i = 0; i < 6; ++i) {
            this.pokeballs[i] = buffer.m_130277_();
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.queryIndex);
        buffer.m_130077_(this.opponentUUID);
        for (int i = 0; i < 6; ++i) {
            buffer.m_130070_(this.pokeballs[i]);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(CustomPayloadEvent.Context context) {
        AcceptDenyScreen.opponent = this;
        Minecraft.m_91087_().m_91152_((Screen)new AcceptDenyScreen(this.queryIndex));
    }
}

