/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class BattleGuiClosedPacket
extends AbstractPixelmonPacket {
    public BattleGuiClosedPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        BattleController b = BattleRegistry.getBattle((Player)player);
        if (b != null && b.battleEnded) {
            BattleRegistry.deRegisterBattle(b);
        }
        PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
        for (Consumer<Optional<BattleController>> consumer : pps.transientData.onceBattleDone) {
            consumer.accept(Optional.ofNullable(b));
        }
        pps.transientData.onceBattleDone.clear();
    }
}

